<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class AlquilerController extends Controller
{
    public function index()
    {
        return view('admin.alquileres.index', [
            'pageTitle' => 'Alquileres Airbnb - UrbanOSS'
        ]);
    }
    
    public function create()
    {
        return view('admin.alquileres.create', [
            'pageTitle' => 'Nuevo Alquiler - UrbanOSS'
        ]);
    }
    
    public function store(Request $request)
    {
        return redirect()->route('admin.alquileres.index')
            ->with('success', 'Alquiler registrado');
    }
    
    public function show($id)
    {
        return view('admin.alquileres.show', [
            'pageTitle' => 'Detalle Alquiler - UrbanOSS',
            'id' => $id
        ]);
    }
    
    public function edit($id)
    {
        return view('admin.alquileres.edit', [
            'pageTitle' => 'Editar Alquiler - UrbanOSS',
            'id' => $id
        ]);
    }
    
    public function update(Request $request, $id)
    {
        return redirect()->route('admin.alquileres.index')
            ->with('success', 'Alquiler actualizado');
    }
    
    public function destroy($id)
    {
        return back()->with('success', 'Alquiler eliminado');
    }
}
