<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\View\View;

class DashboardController extends Controller
{
    public function index(): View
    {
        return view('admin.dashboard.index', [
            'pageTitle' => 'Dashboard Admin - UrbanOSS'
        ]);
    }
    
    public function reports()
    {
        return view('admin.reports.index', [
            'pageTitle' => 'Reportes - UrbanOSS'
        ]);
    }
    
    public function exportReport($type)
    {
        return response()->download(storage_path("app/reports/$type.xlsx"));
    }
    
    public function condominioConfig()
    {
        return view('admin.condominio.config', [
            'pageTitle' => 'Configuración del Condominio - UrbanOSS'
        ]);
    }
    
    public function updateCondominioConfig(Request $request)
    {
        return back()->with('success', 'Configuración actualizada');
    }
}
