<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class MultaController extends Controller
{
    public function index()
    {
        return view('admin.multas.index', [
            'pageTitle' => 'Multas - UrbanOSS'
        ]);
    }
    
    public function create()
    {
        return view('admin.multas.create', [
            'pageTitle' => 'Nueva Multa - UrbanOSS'
        ]);
    }
    
    public function store(Request $request)
    {
        return redirect()->route('admin.multas.index')
            ->with('success', 'Multa registrada');
    }
    
    public function show($id)
    {
        return view('admin.multas.show', [
            'pageTitle' => 'Detalle Multa - UrbanOSS',
            'id' => $id
        ]);
    }
    
    public function edit($id)
    {
        return view('admin.multas.edit', [
            'pageTitle' => 'Editar Multa - UrbanOSS',
            'id' => $id
        ]);
    }
    
    public function update(Request $request, $id)
    {
        return redirect()->route('admin.multas.index')
            ->with('success', 'Multa actualizada');
    }
    
    public function destroy($id)
    {
        return back()->with('success', 'Multa eliminada');
    }
}
