<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class UnidadController extends Controller
{
    public function index()
    {
        return view('admin.unidades.index', [
            'pageTitle' => 'Unidades - UrbanOSS'
        ]);
    }
    
    public function create()
    {
        return view('admin.unidades.create', [
            'pageTitle' => 'Nueva Unidad - UrbanOSS'
        ]);
    }
    
    public function store(Request $request)
    {
        return redirect()->route('admin.unidades.index')
            ->with('success', 'Unidad creada');
    }
    
    public function show($id)
    {
        return view('admin.unidades.show', [
            'pageTitle' => 'Detalle Unidad - UrbanOSS',
            'id' => $id
        ]);
    }
    
    public function edit($id)
    {
        return view('admin.unidades.edit', [
            'pageTitle' => 'Editar Unidad - UrbanOSS',
            'id' => $id
        ]);
    }
    
    public function update(Request $request, $id)
    {
        return redirect()->route('admin.unidades.index')
            ->with('success', 'Unidad actualizada');
    }
    
    public function destroy($id)
    {
        return back()->with('success', 'Unidad eliminada');
    }
    
    public function assign(Request $request, $id)
    {
        return back()->with('success', 'Unidad asignada');
    }
}
