<?php

namespace App\Http\Controllers\Resident;

use App\Http\Controllers\Controller;
use Illuminate\View\View;

class DashboardController extends Controller
{
    public function index(): View
    {
        return view('resident.dashboard.index', [
            'pageTitle' => 'Mi Dashboard - UrbanOSS'
        ]);
    }
    
    public function profile()
    {
        return view('resident.profile', [
            'pageTitle' => 'Mi Perfil - UrbanOSS'
        ]);
    }
    
    public function updateProfile(Request $request)
    {
        return back()->with('success', 'Perfil actualizado');
    }
    
    public function unidades()
    {
        return view('resident.unidades.index', [
            'pageTitle' => 'Mis Unidades - UrbanOSS'
        ]);
    }
    
    public function unidadDetail($id)
    {
        return view('resident.unidades.show', [
            'pageTitle' => 'Detalle Unidad - UrbanOSS',
            'id' => $id
        ]);
    }
    
    public function cameras()
    {
        return view('resident.cameras.index', [
            'pageTitle' => 'Cámaras - UrbanOSS'
        ]);
    }
}
