<?php
namespace App\Http\Controllers\Resident;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class ReservationController extends Controller
{
    public function index()
    {
        return view('resident.reservations.index', [
            'pageTitle' => 'Mis Reservas - UrbanOSS'
        ]);
    }
    
    public function create()
    {
        return view('resident.reservations.create', [
            'pageTitle' => 'Nueva Reserva - UrbanOSS'
        ]);
    }
    
    public function store(Request $request)
    {
        return redirect()->route('resident.reservations')
            ->with('success', 'Reserva creada');
    }
    
    public function destroy($id)
    {
        return back()->with('success', 'Reserva cancelada');
    }
}
