<?php
// ARCHIVO: app/Providers/AuthServiceProvider.php
// VERSIÓN: 1.0 (UrbanOSS)
// DESCRIPCIÓN: Provider para autenticación y autorización
// COMPATIBILIDAD: Laravel 11.47

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;
use App\Models\User;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The model to policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        // 'App\Models\Model' => 'App\Policies\ModelPolicy',
    ];

    /**
     * Register any authentication / authorization services.
     */
    public function boot(): void
    {
        $this->registerPolicies();

        // Gates para control de acceso por rol
        Gate::define('superadmin', function (User $user) {
            return $user->isSuperAdmin();
        });

        Gate::define('admin', function (User $user) {
            return $user->isAdmin() || $user->isSuperAdmin();
        });

        Gate::define('propietario', function (User $user) {
            return $user->isPropietario() || $user->isAdmin() || $user->isSuperAdmin();
        });

        Gate::define('inquilino', function (User $user) {
            return $user->isInquilino() || $user->isPropietario() || $user->isAdmin() || $user->isSuperAdmin();
        });

        Gate::define('guardia', function (User $user) {
            return $user->isGuardia() || $user->isAdmin() || $user->isSuperAdmin();
        });

        // Gate para acceso a condominio específico
        Gate::define('access-condominio', function (User $user, $condominioId) {
            return $user->canAccessCondominio($condominioId);
        });

        // Gate para gestión de usuarios
        Gate::define('manage-users', function (User $user, User $targetUser) {
            return $user->canManageUser($targetUser);
        });
    }
}