#!/bin/bash

echo "=== CREANDO CONTROLADORES URBANOSS ==="

# Función para crear controlador
create_controller() {
    local path="$1"
    local class="$2"
    local content="$3"
    
    echo "Creando: $path"
    mkdir -p "$(dirname "$path")"
    cat > "$path" << CONTENT
<?php
$content
CONTENT
    
    if [ -f "$path" ]; then
        echo "✅ $class creado"
    else
        echo "❌ Error creando $class"
    fi
}

# 6. PaymentController para Admin
create_controller "app/Http/Controllers/Admin/PaymentController.php" "PaymentController" "
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class PaymentController extends Controller
{
    public function index()
    {
        return view('admin.payments.index', [
            'pageTitle' => 'Pagos - UrbanOSS'
        ]);
    }
    
    public function create()
    {
        return view('admin.payments.create', [
            'pageTitle' => 'Nuevo Pago - UrbanOSS'
        ]);
    }
    
    public function store(Request \$request)
    {
        return redirect()->route('admin.pagos.index')
            ->with('success', 'Pago registrado');
    }
    
    public function show(\$id)
    {
        return view('admin.payments.show', [
            'pageTitle' => 'Detalle Pago - UrbanOSS',
            'id' => \$id
        ]);
    }
    
    public function edit(\$id)
    {
        return view('admin.payments.edit', [
            'pageTitle' => 'Editar Pago - UrbanOSS',
            'id' => \$id
        ]);
    }
    
    public function update(Request \$request, \$id)
    {
        return redirect()->route('admin.pagos.index')
            ->with('success', 'Pago actualizado');
    }
    
    public function destroy(\$id)
    {
        return back()->with('success', 'Pago eliminado');
    }
    
    public function approve(\$id)
    {
        return back()->with('success', 'Pago aprobado');
    }
    
    public function reject(\$id)
    {
        return back()->with('success', 'Pago rechazado');
    }
    
    public function generateCodes()
    {
        return back()->with('success', 'Códigos de pago generados');
    }
}"

# 7. PaymentController para Resident
create_controller "app/Http/Controllers/Resident/PaymentController.php" "Resident PaymentController" "
namespace App\Http\Controllers\Resident;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class PaymentController extends Controller
{
    public function index()
    {
        return view('resident.payments.index', [
            'pageTitle' => 'Mis Pagos - UrbanOSS'
        ]);
    }
    
    public function create()
    {
        return view('resident.payments.create', [
            'pageTitle' => 'Nuevo Pago - UrbanOSS'
        ]);
    }
    
    public function store(Request \$request)
    {
        return redirect()->route('resident.pagos')
            ->with('success', 'Pago registrado');
    }
    
    public function uploadProof(Request \$request, \$id)
    {
        return back()->with('success', 'Comprobante subido');
    }
    
    public function history()
    {
        return view('resident.payments.history', [
            'pageTitle' => 'Historial de Pagos - UrbanOSS'
        ]);
    }
}"

# 8. Admin DashboardController
create_controller "app/Http/Controllers/Admin/DashboardController.php" "Admin DashboardController" "
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\View\View;

class DashboardController extends Controller
{
    public function index(): View
    {
        return view('admin.dashboard.index', [
            'pageTitle' => 'Dashboard Admin - UrbanOSS'
        ]);
    }
    
    public function reports()
    {
        return view('admin.reports.index', [
            'pageTitle' => 'Reportes - UrbanOSS'
        ]);
    }
    
    public function exportReport(\$type)
    {
        return response()->download(storage_path(\"app/reports/\$type.xlsx\"));
    }
    
    public function condominioConfig()
    {
        return view('admin.condominio.config', [
            'pageTitle' => 'Configuración del Condominio - UrbanOSS'
        ]);
    }
    
    public function updateCondominioConfig(Request \$request)
    {
        return back()->with('success', 'Configuración actualizada');
    }
}"

# 9. Resident DashboardController
create_controller "app/Http/Controllers/Resident/DashboardController.php" "Resident DashboardController" "
namespace App\Http\Controllers\Resident;

use App\Http\Controllers\Controller;
use Illuminate\View\View;

class DashboardController extends Controller
{
    public function index(): View
    {
        return view('resident.dashboard.index', [
            'pageTitle' => 'Mi Dashboard - UrbanOSS'
        ]);
    }
    
    public function profile()
    {
        return view('resident.profile', [
            'pageTitle' => 'Mi Perfil - UrbanOSS'
        ]);
    }
    
    public function updateProfile(Request \$request)
    {
        return back()->with('success', 'Perfil actualizado');
    }
    
    public function unidades()
    {
        return view('resident.unidades.index', [
            'pageTitle' => 'Mis Unidades - UrbanOSS'
        ]);
    }
    
    public function unidadDetail(\$id)
    {
        return view('resident.unidades.show', [
            'pageTitle' => 'Detalle Unidad - UrbanOSS',
            'id' => \$id
        ]);
    }
    
    public function cameras()
    {
        return view('resident.cameras.index', [
            'pageTitle' => 'Cámaras - UrbanOSS'
        ]);
    }
}"

# 10. Security DashboardController
create_controller "app/Http/Controllers/Security/DashboardController.php" "Security DashboardController" "
namespace App\Http\Controllers\Security;

use App\Http\Controllers\Controller;
use Illuminate\View\View;

class DashboardController extends Controller
{
    public function index(): View
    {
        return view('security.dashboard.index', [
            'pageTitle' => 'Dashboard Seguridad - UrbanOSS'
        ]);
    }
    
    public function residentes()
    {
        return view('security.residentes.index', [
            'pageTitle' => 'Lista de Residentes - UrbanOSS'
        ]);
    }
    
    public function residenteDetail(\$id)
    {
        return view('security.residentes.show', [
            'pageTitle' => 'Detalle Residentes - UrbanOSS',
            'id' => \$id
        ]);
    }
    
    public function cameras()
    {
        return view('security.cameras.index', [
            'pageTitle' => 'Cámaras de Seguridad - UrbanOSS'
        ]);
    }
    
    public function cameraView(\$id)
    {
        return view('security.cameras.view', [
            'pageTitle' => 'Vista Cámara - UrbanOSS',
            'id' => \$id
        ]);
    }
    
    public function alertas()
    {
        return view('security.alertas.index', [
            'pageTitle' => 'Alertas - UrbanOSS'
        ]);
    }
    
    public function resolveAlerta(\$id)
    {
        return back()->with('success', 'Alerta resuelta');
    }
}"

echo "=== CONTROLADORES CREADOS EXITOSAMENTE ==="
