<?php
// ARCHIVO: database/migrations/2024_12_07_000000_add_deleted_at_to_users_table.php
// VERSIÓN: 1.0
// DESCRIPCIÓN: Agrega columna deleted_at para SoftDeletes
// COMPATIBILIDAD: Laravel 11.47, MySQL 5.5+
// EJECUCIÓN: php artisan migrate

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            if (!Schema::hasColumn('users', 'deleted_at')) {
                $table->timestamp('deleted_at')->nullable()->after('updated_at');
            }
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            if (Schema::hasColumn('users', 'deleted_at')) {
                $table->dropColumn('deleted_at');
            }
        });
    }
};