<?php
// ARCHIVO: #4 - database/migrations/2024_12_08_000001_add_extra_fields_to_users_table.php
// VERSIÓN: UrbanOSS 2.0 - Laravel 11.47
// PREDECESORES: users table existente
// RUTA EXACTA: database/migrations/2024_12_08_000001_add_extra_fields_to_users_table.php
// REQUISITOS: Agregar campos faltantes según estructura SQL
// FECHA: 2024-12-08

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Verificar si las columnas ya existen antes de agregarlas
            if (!Schema::hasColumn('users', 'condominio_id')) {
                $table->unsignedBigInteger('condominio_id')->nullable()->after('deleted_at');
                $table->foreign('condominio_id')->references('id')->on('condominios')->onDelete('set null');
            }
            
            if (!Schema::hasColumn('users', 'role')) {
                $table->enum('role', ['superadmin', 'admin', 'propietario', 'inquilino', 'guardia'])
                      ->default('propietario')
                      ->after('condominio_id');
            }
            
            if (!Schema::hasColumn('users', 'telefono')) {
                $table->string('telefono', 20)->nullable()->after('role');
            }
            
            if (!Schema::hasColumn('users', 'documento')) {
                $table->string('documento', 50)->nullable()->after('telefono');
            }
            
            if (!Schema::hasColumn('users', 'foto')) {
                $table->string('foto', 255)->nullable()->after('documento');
            }
            
            if (!Schema::hasColumn('users', 'fecha_ingreso')) {
                $table->date('fecha_ingreso')->nullable()->after('foto');
            }
            
            if (!Schema::hasColumn('users', 'fecha_salida')) {
                $table->date('fecha_salida')->nullable()->after('fecha_ingreso');
            }
            
            if (!Schema::hasColumn('users', 'estado')) {
                $table->enum('estado', ['activo', 'inactivo', 'pendiente'])
                      ->default('pendiente')
                      ->after('fecha_salida');
            }
            
            if (!Schema::hasColumn('users', 'whatsapp')) {
                $table->string('whatsapp', 20)->nullable()->after('estado');
            }
            
            if (!Schema::hasColumn('users', 'configuracion')) {
                $table->json('configuracion')->nullable()->after('whatsapp');
            }
            
            if (!Schema::hasColumn('users', 'ultimo_acceso')) {
                $table->timestamp('ultimo_acceso')->nullable()->after('configuracion');
            }
            
            if (!Schema::hasColumn('users', 'ip_registro')) {
                $table->string('ip_registro', 45)->nullable()->after('ultimo_acceso');
            }
            
            if (!Schema::hasColumn('users', 'observaciones')) {
                $table->text('observaciones')->nullable()->after('ip_registro');
            }
            
            // Índices
            $table->index(['condominio_id', 'role']);
            $table->index(['estado', 'role']);
            $table->index('documento');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // No eliminamos columnas para evitar pérdida de datos
            // Solo revertimos índices
            $table->dropIndex(['condominio_id', 'role']);
            $table->dropIndex(['estado', 'role']);
            $table->dropIndex('documento');
            
            // Remover foreign key si existe
            $table->dropForeign(['condominio_id']);
        });
    }
};