<?php
// ARCHIVO: #7 - resources/views/layouts/app.blade.php
// VERSIÓN: UrbanOSS 3.1 - Laravel 11.47 
// PROBLEMA RESUELTO: Icono gigante del logotipo
// FECHA: 2024-12-08
?>

<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    <title>@yield('title', 'UrbanOSS') - @yield('subtitle', 'Administración de Condominios')</title>
    
    <!-- FontAwesome 6 - SOLO UNA VEZ -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Tailwind CSS via CDN (solo para desarrollo) -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#1e3a5f',
                        secondary: '#2563eb',
                        success: '#059669',
                        danger: '#dc2626',
                        warning: '#d97706',
                        info: '#0891b2'
                    }
                }
            }
        }
    </script>
    
    <!-- Estilos específicos para resolver el problema del icono gigante -->
    <style>
        /* FORZAR que FontAwesome use fuentes, no SVG */
        .fa, .fas, .far, .fal, .fab, .fa-solid, .fa-regular, .fa-light, .fa-thin, .fa-duotone {
            display: inline-block !important;
            font-family: "Font Awesome 6 Free" !important;
            font-weight: 900 !important;
            font-style: normal !important;
            font-variant: normal !important;
            text-rendering: auto !important;
            -webkit-font-smoothing: antialiased !important;
            font-size: inherit !important;
            line-height: 1 !important;
            width: 1em !important;
            height: 1em !important;
            overflow: visible !important;
        }
        
        /* PREVENIR SVG GIGANTES - REGLA CRÍTICA */
        svg:not(:root) {
            width: 1em !important;
            height: 1em !important;
            max-width: 100px !important;
            max-height: 100px !important;
        }
        
        /* Reset para iconos específicamente */
        i.fa-building, 
        i.fas.fa-building,
        [class*="fa-building"] {
            font-size: 1.25rem !important;
            width: auto !important;
            height: auto !important;
            display: inline !important;
        }
        
        /* Estilos globales minimalistas */
        body {
            font-family: 'Inter', system-ui, -apple-system, sans-serif;
            background-color: #f9fafb;
        }
        
        /* Asegurar que los iconos no se estiren */
        .icon-fix {
            display: inline-flex !important;
            align-items: center !important;
            justify-content: center !important;
        }
    </style>
    
    @stack('styles')
</head>
<body class="bg-gray-50">
    <!-- Loader Global -->
    <div id="globalLoader" class="fixed inset-0 bg-white bg-opacity-90 flex items-center justify-center z-50 hidden">
        <div class="text-center">
            <div class="animate-spin rounded-full h-12 w-12 border-4 border-primary border-t-transparent"></div>
            <p class="mt-4 text-gray-600 font-medium">Cargando UrbanOSS...</p>
        </div>
    </div>

    @auth
    <!-- Header para usuarios autenticados -->
    <header class="bg-white shadow-sm border-b border-gray-200 sticky top-0 z-30">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center h-16">
                <!-- Logo - VERSIÓN CORREGIDA -->
                <div class="flex items-center space-x-3">
                    <a href="{{ route('dashboard') }}" class="flex items-center space-x-3 no-underline">
                        <!-- LOGO CORREGIDO - SIN ICONO GIGANTE -->
                        <div class="w-10 h-10 bg-primary rounded-lg flex items-center justify-center icon-fix">
                            <!-- Icono con tamaño fijo explícito -->
                            <i class="fas fa-building text-white" style="font-size: 1.25rem !important; line-height: 1 !important;"></i>
                        </div>
                        <div>
                            <h1 class="text-xl font-bold text-gray-900">URBANOSS</h1>
                            <p class="text-xs text-gray-500">Administración de Condominios</p>
                        </div>
                    </a>
                </div>

                <!-- User Menu -->
                <div class="flex items-center space-x-4">
                    <!-- Notificaciones -->
                    <button class="p-2 rounded-full hover:bg-gray-100 relative">
                        <i class="fas fa-bell text-gray-600"></i>
                        <span class="absolute top-1 right-1 block h-2 w-2 rounded-full bg-red-500"></span>
                    </button>

                    <!-- User Dropdown -->
                    <div class="relative">
                        <button onclick="toggleUserMenu()" class="flex items-center space-x-3 focus:outline-none">
                            <div class="w-10 h-10 rounded-full bg-gradient-to-r from-primary to-secondary flex items-center justify-center text-white font-semibold">
                                {{ strtoupper(substr(auth()->user()->name, 0, 1)) }}
                            </div>
                            <div class="hidden md:block text-left">
                                <p class="text-sm font-medium text-gray-900">{{ auth()->user()->name }}</p>
                                <p class="text-xs text-gray-500 capitalize">{{ auth()->user()->role }}</p>
                            </div>
                            <i class="fas fa-chevron-down text-gray-400"></i>
                        </button>
                        
                        <div id="userDropdown" class="hidden absolute right-0 mt-2 w-56 bg-white rounded-lg shadow-xl border border-gray-200 z-40">
                            <div class="p-4 border-b border-gray-200">
                                <p class="text-sm font-medium text-gray-900">{{ auth()->user()->name }}</p>
                                <p class="text-xs text-gray-500">{{ auth()->user()->email }}</p>
                                <div class="mt-2">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-primary text-white">
                                        {{ ucfirst(auth()->user()->role) }}
                                    </span>
                                </div>
                            </div>
                            <div class="py-1">
                                <a href="{{ route('profile.edit') }}" class="flex items-center px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                    <i class="fas fa-user-circle mr-3 text-gray-400"></i>
                                    Mi Perfil
                                </a>
                                <a href="{{ route('settings') }}" class="flex items-center px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                    <i class="fas fa-cog mr-3 text-gray-400"></i>
                                    Configuración
                                </a>
                            </div>
                            <div class="py-1 border-t border-gray-200">
                                <form method="POST" action="{{ route('logout') }}">
                                    @csrf
                                    <button type="submit" class="flex items-center w-full px-4 py-2 text-sm text-red-600 hover:bg-red-50">
                                        <i class="fas fa-sign-out-alt mr-3"></i>
                                        Cerrar Sesión
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    @endauth

    <!-- Main Content -->
    <main class="py-6">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Session Messages -->
            @if(session('success'))
            <div class="mb-4 bg-green-50 border border-green-400 text-green-700 px-4 py-3 rounded relative" role="alert">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <i class="fas fa-check-circle mr-2"></i>
                        <span>{{ session('success') }}</span>
                    </div>
                    <button onclick="this.parentElement.parentElement.remove()" class="text-green-700 hover:text-green-900">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
            @endif

            @if(session('error'))
            <div class="mb-4 bg-red-50 border border-red-400 text-red-700 px-4 py-3 rounded relative" role="alert">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <i class="fas fa-exclamation-circle mr-2"></i>
                        <span>{{ session('error') }}</span>
                    </div>
                    <button onclick="this.parentElement.parentElement.remove()" class="text-red-700 hover:text-red-900">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
            @endif

            @if($errors->any())
            <div class="mb-4 bg-red-50 border border-red-400 text-red-700 px-4 py-3 rounded relative" role="alert">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <i class="fas fa-exclamation-triangle"></i>
                    </div>
                    <div class="ml-3">
                        <p class="font-medium">Por favor corrige los siguientes errores:</p>
                        <ul class="mt-2 list-disc list-inside text-sm">
                            @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
            @endif

            @yield('content')
        </div>
    </main>

    <!-- Footer -->
    <footer class="bg-white border-t border-gray-200 py-8 mt-16">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
                <div>
                    <div class="flex items-center space-x-3 mb-4">
                        <!-- LOGO FOOTER CORREGIDO -->
                        <div class="w-8 h-8 bg-primary rounded-lg flex items-center justify-center icon-fix">
                            <i class="fas fa-building text-white" style="font-size: 1rem !important;"></i>
                        </div>
                        <span class="text-xl font-bold text-gray-900">URBANOSS</span>
                    </div>
                    <p class="text-gray-600 text-sm">Sistema profesional de administración de condominios.</p>
                </div>
                
                <div>
                    <h3 class="font-semibold text-gray-900 mb-4">Plataforma</h3>
                    <ul class="space-y-2">
                        <li><a href="#" class="text-gray-600 hover:text-primary text-sm">Características</a></li>
                        <li><a href="#" class="text-gray-600 hover:text-primary text-sm">Documentación</a></li>
                        <li><a href="#" class="text-gray-600 hover:text-primary text-sm">Soporte</a></li>
                    </ul>
                </div>
                
                <div>
                    <h3 class="font-semibold text-gray-900 mb-4">Legal</h3>
                    <ul class="space-y-2">
                        <li><a href="#" class="text-gray-600 hover:text-primary text-sm">Términos</a></li>
                        <li><a href="#" class="text-gray-600 hover:text-primary text-sm">Privacidad</a></li>
                        <li><a href="#" class="text-gray-600 hover:text-primary text-sm">Cookies</a></li>
                    </ul>
                </div>
                
                <div>
                    <h3 class="font-semibold text-gray-900 mb-4">Contacto</h3>
                    <ul class="space-y-2">
                        <li class="text-gray-600 text-sm"><i class="fas fa-envelope mr-2"></i> soporte@urbanoss.com</li>
                        <li class="text-gray-600 text-sm"><i class="fas fa-phone mr-2"></i> +51 123 456 789</li>
                        <li class="flex space-x-4 mt-2">
                            <a href="#" class="text-gray-400 hover:text-primary"><i class="fab fa-facebook-f"></i></a>
                            <a href="#" class="text-gray-400 hover:text-primary"><i class="fab fa-twitter"></i></a>
                            <a href="#" class="text-gray-400 hover:text-primary"><i class="fab fa-linkedin-in"></i></a>
                        </li>
                    </ul>
                </div>
            </div>
            
            <div class="border-t border-gray-200 mt-8 pt-8 text-center">
                <p class="text-gray-500 text-sm">&copy; {{ date('Y') }} UrbanOSS. Todos los derechos reservados.</p>
                <p class="text-gray-400 text-xs mt-2">Versión 3.1 - Laravel 11.47</p>
            </div>
        </div>
    </footer>

    <!-- JavaScript -->
    <script>
        // Toggle User Menu
        function toggleUserMenu() {
            const dropdown = document.getElementById('userDropdown');
            dropdown.classList.toggle('hidden');
        }
        
        // Cerrar menú al hacer clic fuera
        document.addEventListener('click', function(event) {
            const dropdown = document.getElementById('userDropdown');
            const userBtn = document.querySelector('button[onclick="toggleUserMenu()"]');
            
            if (dropdown && !dropdown.classList.contains('hidden') && 
                !dropdown.contains(event.target) && 
                userBtn && !userBtn.contains(event.target)) {
                dropdown.classList.add('hidden');
            }
        });
        
        // Mostrar/Ocultar Loader
        document.addEventListener('DOMContentLoaded', function() {
            // Ocultar loader inicial
            setTimeout(() => {
                document.getElementById('globalLoader').classList.add('hidden');
            }, 500);
            
            // Auto-ocultar mensajes
            setTimeout(() => {
                document.querySelectorAll('[role="alert"]').forEach(alert => {
                    alert.style.opacity = '0';
                    alert.style.transition = 'opacity 0.5s';
                    setTimeout(() => alert.remove(), 500);
                });
            }, 5000);
        });
        
        // Mostrar loader en navegación
        document.addEventListener('click', function(e) {
            if (e.target.tagName === 'A' && e.target.href && 
                !e.target.href.includes('#') && 
                !e.target.href.includes('javascript:')) {
                document.getElementById('globalLoader').classList.remove('hidden');
            }
        });
        
        // CSRF Token para AJAX
        window.csrfToken = document.querySelector('meta[name="csrf-token"]').content;
    </script>
    
    @stack('scripts')
</body>
</html>