<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($pageTitle ?? 'Configuración - UrbanOSS'); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-50 min-h-screen">
    <div class="container mx-auto px-4 py-8">
        <div class="max-w-4xl mx-auto">
            <h1 class="text-2xl font-bold text-gray-800 mb-6">Configuración del Sistema</h1>
            
            <div class="bg-white rounded-xl shadow-sm p-6 mb-6">
                <h2 class="text-lg font-medium text-gray-800 mb-4">Información General</h2>
                <div class="grid md:grid-cols-2 gap-4">
                    <div>
                        <p class="text-sm text-gray-500">Nombre del Sistema</p>
                        <p class="font-medium">UrbanOSS</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Versión</p>
                        <p class="font-medium">3.1 - Laravel 11.47</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">URL</p>
                        <p class="font-medium"><?php echo e(config('app.url')); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Entorno</p>
                        <p class="font-medium"><?php echo e(config('app.env')); ?></p>
                    </div>
                </div>
            </div>
            
            <div class="bg-white rounded-xl shadow-sm p-6">
                <h2 class="text-lg font-medium text-gray-800 mb-4">Configuraciones Disponibles</h2>
                <div class="space-y-4">
                    <div class="p-4 border rounded-lg">
                        <h3 class="font-medium text-gray-800 mb-2">Configuración de Correo</h3>
                        <p class="text-sm text-gray-600 mb-3">Configurar servidor de correo para notificaciones</p>
                        <button class="px-4 py-2 bg-gray-100 text-gray-700 rounded-lg text-sm">
                            Configurar (Próximamente)
                        </button>
                    </div>
                    
                    <div class="p-4 border rounded-lg">
                        <h3 class="font-medium text-gray-800 mb-2">Configuración de Pagos</h3>
                        <p class="text-sm text-gray-600 mb-3">Configurar pasarelas de pago integradas</p>
                        <button class="px-4 py-2 bg-gray-100 text-gray-700 rounded-lg text-sm">
                            Configurar (Próximamente)
                        </button>
                    </div>
                    
                    <div class="p-4 border rounded-lg">
                        <h3 class="font-medium text-gray-800 mb-2">Configuración de Seguridad</h3>
                        <p class="text-sm text-gray-600 mb-3">Ajustes de seguridad y autenticación</p>
                        <button class="px-4 py-2 bg-gray-100 text-gray-700 rounded-lg text-sm">
                            Configurar (Próximamente)
                        </button>
                    </div>
                </div>
            </div>
            
            <div class="mt-6">
                <a href="<?php echo e(url()->previous()); ?>" class="text-blue-600 hover:text-blue-800 flex items-center">
                    <i class="fas fa-arrow-left mr-2"></i> Volver al Dashboard
                </a>
            </div>
        </div>
    </div>
</body>
</html>
<?php /**PATH /home/urbanoss/public_html/plataforma/resources/views/settings/index.blade.php ENDPATH**/ ?>