<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($pageTitle ?? 'Mi Perfil - UrbanOSS'); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-50 min-h-screen">
    <div class="container mx-auto px-4 py-8">
        <div class="max-w-2xl mx-auto">
            <div class="bg-white rounded-xl shadow-sm p-6">
                <h1 class="text-2xl font-bold text-gray-800 mb-6">Mi Perfil</h1>
                
                <form method="POST" action="<?php echo e(route('profile.update')); ?>">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    
                    <div class="mb-4">
                        <label class="block text-gray-700 text-sm font-medium mb-2">Nombre</label>
                        <input type="text" name="name" value="<?php echo e(old('name', $user->name)); ?>"
                               class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-blue-500">
                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="mb-6">
                        <label class="block text-gray-700 text-sm font-medium mb-2">Email</label>
                        <input type="email" name="email" value="<?php echo e(old('email', $user->email)); ?>"
                               class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-blue-500">
                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="flex justify-between">
                        <a href="<?php echo e(url()->previous()); ?>" class="px-4 py-2 border rounded-lg text-gray-700">
                            Cancelar
                        </a>
                        <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                            Guardar Cambios
                        </button>
                    </div>
                </form>
                
                <div class="mt-8 pt-6 border-t">
                    <h3 class="font-medium text-gray-800 mb-3">Información de la Cuenta</h3>
                    <div class="space-y-2 text-sm">
                        <p><span class="text-gray-500">Rol:</span> <span class="font-medium"><?php echo e(ucfirst($user->role)); ?></span></p>
                        <p><span class="text-gray-500">Estado:</span> <span class="font-medium"><?php echo e(ucfirst($user->estado)); ?></span></p>
                        <p><span class="text-gray-500">Miembro desde:</span> <span class="font-medium"><?php echo e($user->created_at->format('d/m/Y')); ?></span></p>
                    </div>
                </div>
            </div>
            
            <div class="mt-4">
                <a href="<?php echo e(url()->previous()); ?>" class="text-blue-600 hover:text-blue-800 flex items-center">
                    <i class="fas fa-arrow-left mr-2"></i> Volver
                </a>
            </div>
        </div>
    </div>
</body>
</html>
<?php /**PATH /home/urbanoss/public_html/plataforma/resources/views/profile/edit.blade.php ENDPATH**/ ?>