<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($pageTitle ?? 'Iniciar Sesión - UrbanOSS'); ?></title>
    
    <!-- Favicon con cache buster -->
    <link rel="icon" href="<?php echo e(url('/favicon.ico')); ?>?v=3" type="image/x-icon">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {
                            600: '#2563eb',
                            700: '#1d4ed8',
                        }
                    }
                }
            }
        }
    </script>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        .login-bg {
            background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%);
        }
        .login-card {
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1);
        }
    </style>
</head>
<body class="min-h-screen flex items-center justify-center p-4 login-bg">
    
    <div class="max-w-md w-full">
        <!-- Logo -->
        <div class="text-center mb-8">
            <div class="inline-flex items-center justify-center w-16 h-16 bg-white rounded-2xl mb-4">
                <i class="fas fa-building text-primary-600 text-3xl"></i>
            </div>
            <h1 class="text-3xl font-bold text-white">
                Urban<span class="text-yellow-300">OSS</span>
            </h1>
            <p class="text-white opacity-90 mt-2">
                Sistema de Administración de Condominios
            </p>
        </div>
        
        <!-- Card de Login -->
        <div class="bg-white rounded-2xl login-card p-8">
            <h2 class="text-2xl font-bold text-gray-800 mb-6 text-center">
                Iniciar Sesión
            </h2>
            
            <!-- Mensajes -->
            <?php if(session('error')): ?>
                <div class="mb-4 p-3 bg-red-50 border border-red-200 text-red-700 rounded-lg">
                    <i class="fas fa-exclamation-circle mr-2"></i>
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>
            
            <?php if(session('success')): ?>
                <div class="mb-4 p-3 bg-green-50 border border-green-200 text-green-700 rounded-lg">
                    <i class="fas fa-check-circle mr-2"></i>
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>
            
            <?php if(session('info')): ?>
                <div class="mb-4 p-3 bg-blue-50 border border-blue-200 text-blue-700 rounded-lg">
                    <i class="fas fa-info-circle mr-2"></i>
                    <?php echo e(session('info')); ?>

                </div>
            <?php endif; ?>
            
            <?php if(isset($condominio)): ?>
                <div class="mb-4 p-3 bg-primary-50 border border-primary-200 text-primary-700 rounded-lg">
                    <i class="fas fa-building mr-2"></i>
                    <strong><?php echo e($condominio->nombre); ?></strong>
                </div>
            <?php endif; ?>
            
            <!-- Formulario SIMPLIFICADO -->
            <form method="POST" action="<?php echo e(route('login')); ?>" id="loginForm">
                <?php echo csrf_field(); ?>
                
                <!-- Email -->
                <div class="mb-4">
                    <label class="block text-gray-700 text-sm font-medium mb-2">
                        <i class="fas fa-envelope mr-2"></i>Correo Electrónico
                    </label>
                    <input type="email" name="email" required
                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-primary-500"
                           placeholder="usuario@ejemplo.com"
                           value="<?php echo e(old('email')); ?>"
                           autocomplete="email">
                </div>
                
                <!-- Contraseña -->
                <div class="mb-6">
                    <label class="block text-gray-700 text-sm font-medium mb-2">
                        <i class="fas fa-lock mr-2"></i>Contraseña
                    </label>
                    <input type="password" name="password" required
                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-primary-500"
                           placeholder="••••••••"
                           autocomplete="current-password">
                </div>
                
                <!-- Recuerdame -->
                <div class="mb-6">
                    <label class="flex items-center">
                        <input type="checkbox" name="remember" 
                               class="rounded border-gray-300 text-primary-600 shadow-sm focus:border-primary-300 focus:ring focus:ring-primary-200">
                        <span class="ml-2 text-sm text-gray-600">Mantener sesión iniciada</span>
                    </label>
                </div>
                
                <!-- Botón de Login -->
                <button type="submit"
                        class="w-full bg-primary-600 text-white py-3 px-4 rounded-lg font-medium hover:bg-primary-700 transition duration-200"
                        id="submitBtn">
                    <i class="fas fa-sign-in-alt mr-2"></i>Iniciar Sesión
                </button>
            </form>
            
            <!-- Enlaces -->
            <div class="mt-6 pt-6 border-t border-gray-200">
                <!-- Recuperar contraseña -->
                <div class="mb-3">
                    <a href="<?php echo e($passwordResetUrl ?? '#'); ?>" 
                       class="text-primary-600 hover:text-primary-800 text-sm flex items-center">
                        <i class="fas fa-key mr-2"></i>¿Olvidaste tu contraseña?
                    </a>
                </div>
                
                <!-- Información de registro -->
                <div class="text-sm text-gray-600 mb-4">
                    <i class="fas fa-user-plus mr-2"></i>
                    <?php echo e($registrationInfo['message'] ?? 'Para registrarse, contacte al administrador.'); ?>

                </div>
                
                <!-- Volver al inicio -->
                <div>
                    <a href="<?php echo e(url('/')); ?>" 
                       class="text-gray-500 hover:text-gray-700 text-sm flex items-center">
                        <i class="fas fa-arrow-left mr-2"></i>Volver a la página principal
                    </a>
                </div>
            </div>
        </div>
        
        <!-- Footer -->
        <div class="mt-6 text-center text-white text-sm opacity-80">
            <p>© <?php echo e(date('Y')); ?> UrbanOSS. Todos los derechos reservados.</p>
            <p class="mt-1">Versión 3.1 - Laravel 11.47</p>
            <div class="mt-2">
                <span class="inline-flex items-center">
                    <span class="w-2 h-2 bg-green-400 rounded-full mr-2 animate-pulse"></span>
                    Sistema operativo
                </span>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.getElementById('loginForm');
            const submitBtn = document.getElementById('submitBtn');
            
            if (form && submitBtn) {
                let isSubmitting = false;
                
                form.addEventListener('submit', function(e) {
                    if (isSubmitting) {
                        e.preventDefault();
                        return;
                    }
                    
                    isSubmitting = true;
                    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Verificando...';
                    submitBtn.disabled = true;
                    
                    // Validación básica
                    const email = form.querySelector('input[name="email"]');
                    const password = form.querySelector('input[name="password"]');
                    
                    if (!email.value || !password.value) {
                        isSubmitting = false;
                        submitBtn.innerHTML = '<i class="fas fa-sign-in-alt mr-2"></i>Iniciar Sesión';
                        submitBtn.disabled = false;
                        return;
                    }
                });
            }
        });
    </script>
</body>
</html><?php /**PATH /home/urbanoss/public_html/plataforma/resources/views/auth/login.blade.php ENDPATH**/ ?>